//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate different Line Codes - 1(Unipolar RZ)

clear;
close;
clc;
x=[1 0 1 0 0 1 1 0]//Data Stream

//RZ
z=0;//Starting value on x axis
for i=1:length(x)
    t=[z:z+1]//Set of x cordinates for current bit duration
        subplot(2,1,1)
        a=gca();
        a.data_bounds=[0,-1.5;length(x),1.5]
        a.grid=[1,-1]
        title('Data')
        plot(t,x(i))//Plot current data bit
    
    t=[z:0.5:z+0.5]//Set of x cordinates for first half bit duration
        subplot(2,1,2)
        a=gca();
        a.data_bounds=[0,-1.5;length(x),1.5]
        a.grid=[1,-1]
        title('Polar RZ')
        if(x(i)==0)
            plot(t,0)//Plot 0 for first half bit duration
        else
            plot(t,1)//Plot 1 for first half bit duration
        end
    t=[z+0.5:0.5:z+1]//Set of x cordinates for second half bit duration
    plot(t,0)//Plot 0 for second half bit duration
    
    z=z+1;//Increament starting value on x axis by one bit period
end
